package nemosofts.voxradio.activity;

import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

import androidx.activity.EdgeToEdge;
import androidx.appcompat.widget.Toolbar;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.material.Toasty;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.utils.IfSupported;

public class AboutUsActivity extends AppCompatActivity {

    private TextView author;
    private TextView email;
    private TextView website;
    private TextView contact;
    private TextView description;
    private TextView version;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        IfSupported.isRTL(this);
        IfSupported.isScreenshot(this);
        EdgeToEdge.enable(this);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.bg_page), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
            return insets;
        });

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        toolbar.setNavigationOnClickListener(view -> finish());

        author = findViewById(R.id.tv_company);
        email = findViewById(R.id.tv_email);
        website = findViewById(R.id.tv_website);
        contact = findViewById(R.id.tv_contact);
        description = findViewById(R.id.tv_app_des);
        version = findViewById(R.id.tv_version);

        setAboutUs();
        setupButton();
    }

    private void setupButton() {

        findViewById(R.id.ll_share).setOnClickListener(v -> onClick(getResources().getString(R.string.share)));
        findViewById(R.id.ll_rate).setOnClickListener(v -> onClick(getResources().getString(R.string.rate_the_app)));
        findViewById(R.id.ll_domain).setOnClickListener(v -> onClick(getResources().getString(R.string.website)));
        findViewById(R.id.ll_contact).setOnClickListener(v -> onClick(getResources().getString(R.string.contact)));
        findViewById(R.id.ll_email).setOnClickListener(v -> onClick(getResources().getString(R.string.email)));
        findViewById(R.id.ll_more).setOnClickListener(v -> onClick(getResources().getString(R.string.more_apps)));
    }

    private void setAboutUs() {
        if (Callback.getItemAbout() == null) {
            return;
        }
        author.setText(!Callback.getItemAbout().author().trim().isEmpty() ? Callback.getItemAbout().author() : "");
        email.setText(!Callback.getItemAbout().email().trim().isEmpty() ? Callback.getItemAbout().email() : "");
        website.setText(!Callback.getItemAbout().website().trim().isEmpty() ? Callback.getItemAbout().website() : "");
        contact.setText(!Callback.getItemAbout().contact().trim().isEmpty() ? Callback.getItemAbout().contact() : "");
        description.setText(!Callback.getItemAbout().description().trim().isEmpty() ? Callback.getItemAbout().description() : "");
        version.setText(BuildConfig.VERSION_NAME);
    }

    public void onClick(String type) {
        if (type != null && type.isEmpty()){
            return;
        }
        if (getResources().getString(R.string.share).equals(type)){
            final String appName = getPackageName();
            Intent sendIntent = new Intent();
            sendIntent.setAction(Intent.ACTION_SEND);
            sendIntent.putExtra(Intent.EXTRA_TITLE, getString(R.string.app_name));
            sendIntent.putExtra(Intent.EXTRA_TEXT, "http://play.google.com/store/apps/details?id=" + appName);
            sendIntent.setType("text/plain");
            startActivity(Intent.createChooser(sendIntent, "Share"));
        }
        else if (getResources().getString(R.string.rate_the_app).equals(type)){
            final String appName = getPackageName();
            shareUrl("http://play.google.com/store/apps/details?id=" + appName);
        }
        else if (getResources().getString(R.string.website).equals(type)){
            shareUrl(Callback.getItemAbout().website());
        }
        else if (getResources().getString(R.string.contact).equals(type)){
            String contactData = Callback.getItemAbout().contact(); // use country code with your phone number
            if (!contactData.isEmpty()){
                String url = "https://api.whatsapp.com/send?phone=" + contactData;
                try {
                    PackageManager pm = getPackageManager();
                    pm.getPackageInfo("com.whatsapp", PackageManager.GET_ACTIVITIES);
                    Intent i = new Intent(Intent.ACTION_VIEW);
                    i.setData(Uri.parse(url));
                    startActivity(i);
                } catch (PackageManager.NameNotFoundException e) {
                    Log.e("AboutUsActivity", "Failed to whatsapp", e);
                }
            }
        }
        else if (getResources().getString(R.string.email).equals(type)){
            String emailData = Callback.getItemAbout().email();
            Intent intent = new Intent(Intent.ACTION_SENDTO);
            intent.setData(Uri.parse("mailto:")); // only email apps should handle this
            intent.putExtra(Intent.EXTRA_EMAIL, new String[]{emailData,});
            intent.putExtra(Intent.EXTRA_SUBJECT, getString(R.string.app_name));
            intent.putExtra(Intent.EXTRA_TEXT, "note");
            if (intent.resolveActivity(getPackageManager()) != null) {
                startActivity(intent);
            }
        }
        else if (getResources().getString(R.string.more_apps).equals(type)){
            shareUrl(Callback.getItemAbout().moreApps());
        }
    }

    private void shareUrl(String webURL) {
        if (webURL == null){
            Toasty.makeText(AboutUsActivity.this, "Invalid URL", Toasty.ERROR);
            return;
        }
        if (webURL.contains("http://") || webURL.contains("https://")){
            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(webURL)));
        } else if (!webURL.isEmpty()){
            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://"+webURL)));
        } else {
            Toasty.makeText(AboutUsActivity.this, "Invalid URL", Toasty.ERROR);
        }
    }

    @Override
    public int setContentViewID() {
        return R.layout.activity_about_us;
    }
}